/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import panther.util.general.ErrorUtils;
import panther.util.resource.Resources;
import panther.util.unicon.StringUtil;

public class BobsConnectionPoolDriver
implements Driver {
    private static final BobsConnectionPoolDriver singleton = BobsConnectionPoolDriver.initializeDriver();
    private static final String URL_PREFIX = "jdbc:bcp:";

    private BobsConnectionPoolDriver() {
    }

    public String toString() {
        return "BobsConnectionPoolDriver (singleton)";
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        String string2;
        if (!this.acceptsURL(string)) {
            return null;
        }
        String string3 = string.substring(URL_PREFIX.length());
        List list = StringUtil.listFromDelimitedString(string3, ":");
        String string4 = list.size() >= 1 ? (String)list.get(0) : null;
        String string5 = string2 = list.size() >= 2 ? (String)list.get(1) : "anonymous";
        if (properties.containsKey("requester")) {
            string2 = (String)properties.get("requester");
        }
        if (string4 == null) {
            throw new SQLException("The URL used with BobsConnectionPoolDriver must include a token with the pool name");
        }
        try {
            return Resources.getConnection(string4, string2);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new SQLException("Error while attempting to allocate a Connection using the url " + string + "\n\nUnderlying exception:\n" + ErrorUtils.stackTrace(throwable));
        }
    }

    public boolean acceptsURL(String string) throws SQLException {
        return string != null && string.toLowerCase().startsWith(URL_PREFIX);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return null;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    private void register() throws SQLException {
        DriverManager.registerDriver(this);
    }

    private static BobsConnectionPoolDriver initializeDriver() {
        try {
            BobsConnectionPoolDriver bobsConnectionPoolDriver = new BobsConnectionPoolDriver();
            bobsConnectionPoolDriver.register();
            return bobsConnectionPoolDriver;
        }
        catch (Exception exception) {
            throw new Error("Unable to initialize BobsConnectionPool", exception);
        }
    }
}

